<?php namespace Visiosoft\StoreModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Support\Facades\Route;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\StoreModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\StoreModule\Doping\DopingRepository;
use Anomaly\Streams\Platform\Model\Store\StoreDopingsEntryModel;
use Visiosoft\StoreModule\Doping\DopingModel;
use Visiosoft\StoreModule\Doping\Listeners\ApproveOrderStoreDoping;
use Visiosoft\StoreModule\DopingType\Contract\DopingTypeRepositoryInterface;
use Visiosoft\StoreModule\DopingType\DopingTypeRepository;
use Anomaly\Streams\Platform\Model\Store\StoreDopingTypesEntryModel;
use Visiosoft\StoreModule\DopingType\DopingTypeModel;
use Anomaly\Streams\Platform\Model\Store\StoreThumbSliderEntryModel;
use Visiosoft\CartsModule\Cart\Event\CartRemove;
use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\StoreModule\Category\CategoryRepository;
use Anomaly\Streams\Platform\Model\Store\StoreCategoryEntryModel;
use Visiosoft\StoreModule\Category\CategoryModel;
use Anomaly\Streams\Platform\Model\Store\StorePricesEntryModel;
use Maatwebsite\Excel\ExcelServiceProvider;
use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\OrdersModule\Events\StoreOrderApproved;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\Listeners\ApproveStore;
use Visiosoft\StoreModule\Price\Contract\PriceRepositoryInterface;
use Visiosoft\StoreModule\Price\PriceModel;
use Visiosoft\StoreModule\Price\PriceRepository;
use Visiosoft\StoreModule\Store\Listeners\RemoveStoreCart;
use Visiosoft\StoreModule\Store\StoreRegister\StoreRegisterFormBuilder;
use Visiosoft\StoreModule\ThumbSlider\Contract\ThumbSliderRepositoryInterface;
use Visiosoft\StoreModule\ThumbSlider\ThumbSliderModel;
use Visiosoft\StoreModule\ThumbSlider\ThumbSliderRepository;
use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;
use Visiosoft\StoreModule\User\UserRepository;
use Anomaly\Streams\Platform\Model\Store\StoreUserEntryModel;
use Visiosoft\StoreModule\User\UserModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\StoreRepository;
use Anomaly\Streams\Platform\Model\Store\StoreStoreEntryModel;
use Visiosoft\StoreModule\Store\StoreModel;

class StoreModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        StoreModulePlugin::class
    ];

    protected $routes = [
        // Admin DopingsController
        'admin/store/dopings' => 'Visiosoft\StoreModule\Http\Controller\Admin\DopingsController@index',
        'admin/store/dopings/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\DopingsController@create',
        'admin/store/dopings/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\DopingsController@edit',

        // Admin DopingTypesController
        'admin/store/doping_types' => 'Visiosoft\StoreModule\Http\Controller\Admin\DopingTypesController@index',
        'admin/store/doping_types/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\DopingTypesController@create',
        'admin/store/doping_types/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\DopingTypesController@edit',

        // Admin CategoryController
        'admin/store/category' => 'Visiosoft\StoreModule\Http\Controller\Admin\CategoryController@index',
        'admin/store/category/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\CategoryController@create',
        'admin/store/category/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\CategoryController@edit',

        // Admin UserController
        'admin/store/user' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@index',
        'admin/store/user/export' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@export',
        'admin/store/user/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@create',
        'admin/store/user/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@edit',

        // Admin StoreController
        'admin/store/export' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@export',
        'admin/store/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@create',
        'admin/store' => [
            'as' => 'visiosoft.module.store::admin_store',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@index',
        ],
        'admin/store/edit/{id}' => [
            'as' => 'visiosoft.module.store::admin.edit',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@edit',
        ],

        // StoreController
        'admin/store/add-domain/{id}' => 'Visiosoft\StoreModule\Http\Controller\StoreController@addDomain',
        'store/list' => [
            'as' => 'store::list',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@listStores'
        ],
        's/{slug}/edit/{id}' => [
            'middleware' => 'auth',
            'as' => 'store::edit',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@edit',
        ],
        's/{slug}/save/{id}' => [
            'as' => 'store::edit_save',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@store',
        ],
        'store/create' => [
            'middleware' => 'auth',
            'as' => 'store::create',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@create',
        ],
        'store/{slug}' => [
            'as' => 'store::view',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@index',
        ],
        'store/{slug}/detail' => [
            'as' => 'store::detail',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@storeDetail',
        ],
        's/{slug}/add-user' => [
            'as' => 'store::add-user',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@addUser',
        ],
        's/{slug}/remove-user/{id}' => [
            'as' => 'store::remove-user',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@removeUser',
        ],
        'store/store-detail-page/{id}/update' => [
            'as' => 'store::detail-update',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@storeDetailUpdate',
        ],
        'store/panel/{slug}' => [
            'middleware' => 'auth',
            'as' => 'store::store_panel',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@panel',
        ],
        'store/{store_slug}/consultant/{user_id}' => [
            'as' => 'visiosoft.module.store::store.consultant.show',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@showConsultant',
        ],

        // DopingsController
        'store-doping/add-cart/{slug}' => [
            'as' => 'visiosoft.module.store::doping.add_cart',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\DopingsController@addCart',
        ],
    ];

    protected $listeners = [
        StoreOrderApproved::class => [
            ApproveStore::class
        ],
        CartRemove::class => [
            RemoveStoreCart::class,
        ],
        OrderApproved::class => [
            ApproveOrderStoreDoping::class
        ],
    ];

    protected $aliases = [
        'Excel' => Excel::class,
    ];

    protected $bindings = [
        StoreDopingsEntryModel::class => DopingModel::class,
        StoreDopingTypesEntryModel::class => DopingTypeModel::class,
        StoreCategoryEntryModel::class => CategoryModel::class,
        StoreUserEntryModel::class => UserModel::class,
        StoreStoreEntryModel::class => StoreModel::class,
        StorePricesEntryModel::class => PriceModel::class,
        StoreThumbSliderEntryModel::class => ThumbSliderModel::class,
        'store-form' => StoreFormBuilder::class,
    ];

    protected $singletons = [
        DopingRepositoryInterface::class => DopingRepository::class,
        DopingTypeRepositoryInterface::class => DopingTypeRepository::class,
        CategoryRepositoryInterface::class => CategoryRepository::class,
        UserRepositoryInterface::class => UserRepository::class,
        StoreRepositoryInterface::class => StoreRepository::class,
        PriceRepositoryInterface::class => PriceRepository::class,
        ThumbSliderRepositoryInterface::class => ThumbSliderRepository::class,
        'store-register' => StoreRegisterFormBuilder::class
    ];

    protected $providers = [
        ExcelServiceProvider::class,
    ];

    public function boot()
    {
        if (setting_value('visiosoft.module.store::use_subdomain_routing')) {
            Route::group(['domain' => '{slug}.' . setting_value('streams::domain')], function () {
                Route::get('/', [\Visiosoft\StoreModule\Http\Controller\StoreController::class, 'index'])
                    ->name('store::subdomain_view');
            });
        }
    }
}
