<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Addon\FieldType\FieldTypeCollection;
use Anomaly\Streams\Platform\Assignment\AssignmentModel;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Table\AssignmentTableBuilder;
use Anomaly\Streams\Platform\Field\Form\FieldFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\UsersModule\Assignment\AssignmentObserver;
use Visiosoft\StoreModule\Store\StoreModel;

class FieldsController extends AdminController
{
    public function index(AssignmentTableBuilder $table, StoreModel $store)
    {
        AssignmentModel::observe(AssignmentObserver::class);

        return $table
            ->setOption('sortable', true)
            ->setStream($store->getStream())
            ->render();
    }

    public function choose(FieldTypeCollection $fieldTypes)
    {
        return $this->view->make('visiosoft.module.store::admin/fields/choose', ['field_types' => $fieldTypes]);
    }

    public function create(FieldFormBuilder $form, StoreModel $store, FieldTypeCollection $fieldTypes)
    {
        $form
            ->setStream($store->getStream())
            ->setOption('auto_assign', true)
            ->setFieldType($fieldTypes->get($this->request->get('field_type')));

        return $form->render();
    }

    public function edit(AssignmentRepositoryInterface $assignments, FieldFormBuilder $form, StoreModel $model, $id)
    {
        $assignment = $assignments->find($id);

        return $form
            ->setStream($model->getStream())
            ->render($assignment->getFieldId());
    }
}
