<?php namespace Visiosoft\StoreModule\Store\StoreRegister\Command;

use Anomaly\UsersModule\Role\Command\GetRole;
use Visiosoft\StoreModule\Store\StoreRegister\StoreRegisterFormBuilder;
use Illuminate\Foundation\Bus\DispatchesJobs;

/**
 * Class AssociateActivationRoles
 *
 * @link          http://openclassify.com/
 * @author        OpenClassify, Inc. <support@openclassify.com>
 * @author        Visiosoft Inc <support@openclassify.com>
 */
class AssociateActivationRoles
{

    use DispatchesJobs;

    /**
     * The form builder.
     *
     * @var StoreRegisterFormBuilder
     */
    protected $builder;

    /**
     * Create a new AssociateActivationRoles instance.
     *
     * @param StoreRegisterFormBuilder $builder
     */
    public function __construct(StoreRegisterFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     */
    public function handle()
    {
        /* @var UserInterface $user */
        $user = $this->builder->getFormEntry();

        foreach ($this->builder->getRoles() as $role) {
            if ($role = $this->dispatch(new GetRole($role))) {
                $user->attachRole($role);
            }
        }
    }
}
