<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\StoreExports;
use Visiosoft\StoreModule\Store\Table\StoreTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class StoreController extends AdminController
{
    private $storeRepository;

    public function __construct(StoreRepositoryInterface $storeRepository)
    {
        parent::__construct();
        $this->storeRepository = $storeRepository;
    }

    public function index(StoreTableBuilder $table)
    {
        return $table->render();
    }

    public function create(StoreFormBuilder $form)
    {
        $form->setOption('heading', "visiosoft.module.store::field");

        return $form->render();
    }

    public function edit(StoreFormBuilder $form, $id)
    {
        $form->setOption('heading', "visiosoft.module.store::field");

        return $form->render($id);
    }

    public function verify($id)
    {
        try {
            if (!$store = $this->storeRepository->find($id)) {
                throw new \Exception(trans('visiosoft.module.store::message.store_not_exist'));
            }

            if ($store->verified) {
                throw new \Exception(trans('visiosoft.module.store::message.store_already_verified'));
            }

            $store->verify();

            $this->messages->success(trans('visiosoft.module.store::message.store_verified'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect('admin/store');
    }

    public function refute($id)
    {
        try {
            if (!$store = $this->storeRepository->find($id)) {
                throw new \Exception(trans('visiosoft.module.store::message.store_not_exist'));
            }

            if (!$store->verified) {
                throw new \Exception(trans('visiosoft.module.store::message.store_already_refuted'));
            }

            $store->refute();

            $this->messages->success(trans('visiosoft.module.store::message.store_refuted'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect('admin/store');
    }

    public function export(StoreRepositoryInterface $store)
    {
        return Excel::download(new StoreExports, 'store.xlsx');
    }
}
