<?php namespace Visiosoft\StoreModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Facades\DB;
use Visiosoft\StoreModule\Seed\RegisterInstructionSeeder;

class StoreModuleSeeder extends Seeder
{

    /**
     * The disk repository.
     *
     * @var DiskRepositoryInterface
     */
    protected $disks;

    /**
     * The folder repository.
     *
     * @var FolderRepositoryInterface
     */
    protected $folders;

    /**
     * Create a new FolderSeeder instance.
     *
     * @param DiskRepositoryInterface $disks
     * @param FolderRepositoryInterface $folders
     */
    public function __construct(DiskRepositoryInterface $disks, FolderRepositoryInterface $folders)
    {
        parent::__construct();

        $this->disks = $disks;
        $this->folders = $folders;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        //Create Store Icon Folder
        if (!$this->folders->findBySlug('store-icon')) {
            $disk = $this->disks->findBySlug('local');

            $this->folders->create([
                'en' => [
                    'name' => 'Store Icon',
                    'description' => 'A folder for Store Icons.',
                ],
                'slug' => 'store_icon',
                'disk' => $disk,
                'allowed_types' => [
                    'jpg', 'jpeg', 'png', 'ico', 'svg'
                ],
            ]);
        };


        // Register Instruction Seeder
        $this->call(RegisterInstructionSeeder::class);

        $repository = "https://raw.githubusercontent.com/openclassify/Openclassify-Demo-Data/master/";
        file_put_contents(storage_path('store.sql'), fopen($repository . "store.sql", 'r'));
        DB::unprepared(file_get_contents(storage_path('store.sql')));

    }
}