<?php namespace Visiosoft\StoreModule\Category;

use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\StoreModule\Store\StoreModel;
use function Clue\StreamFilter\fun;

class CategoryRepository extends EntryRepository implements CategoryRepositoryInterface
{
    protected $model;
    protected $storeModel;

    public function __construct(CategoryModel $model)
    {
        $this->model = $model;
    }

    public function getStoreCategories()
    {
        return $this->newQuery()->where('category_type','store')->get();
    }
    public function getCompanyCategories()
    {
        return $this->newQuery()->where('category_type','company')->get();

    }
}
