<?php

return [
    // General
    "default_banner_image" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "default_store_logo" => [
        "type" => "anomaly.field_type.file",
        "bind" => "visiosoft.module.store::default_store_logo",
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    // End General

    // Subdomain
    "use_subdomain_routing" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => false,
        ]
    ],
    "api_token" => "anomaly.field_type.text",
    "site_slug" => "anomaly.field_type.text",
    // End Subdomain

    // Homepage
    'homeShowcaseLimit' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 5,
        ],
    ],
    // End Homepage

    // Pricing
    'enable_store_prices' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
            "mode" => "checkbox",
        ],
    ],
    'default_store_price' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 10,
        ],
    ],
    // End Pricing

    // Profile
    'show_website' => 'anomaly.field_type.boolean',
    'show_country' => 'anomaly.field_type.boolean',
    // End Profile

    // Stores list
    'view_type' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'options' => [
                'gallery' => 'visiosoft.module.store::setting.gallery_view',
                'list' => 'visiosoft.module.store::setting.list_view'
            ]
        ]
    ],
    "list_banner_image" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "list_banner_url" => [
        "type" => "anomaly.field_type.url",
        "config" => [
            "default_value" => '#',
        ]
    ],
    "show_cat_filter" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => true,
        ]
    ],
    "show_date_filter" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => true,
        ]
    ],
    "store_list_redirection" => [
        "type"   => "anomaly.field_type.select",
        "config" => [
            "options"       => [
                'list' => 'visiosoft.module.store::setting.list_store_products',
                'profile' => 'visiosoft.module.store::setting.store_profile',
            ],
            "default_value" => 'list',
            "mode"          => "dropdown",
        ]
    ],
    "show_searchbar_list" => [
        "type" => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
        ]
    ],
    "list_seo_keywords" => "anomaly.field_type.tags",
    'hide_location_filter_categories' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'options' => function (\Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->all()->pluck('name', 'id')->all();
            },
        ],
    ],
    // End Stores list

    // Store ads
    'store_detail_page' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'show_detail_page' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    "default_detail_page" => [
        "type" => 'anomaly.field_type.editor',
        "instructions" => "{{land_phone}}   {{gsm_phone}}
                            {{slug}}
                            {{summary}}
                            {{detailed_description}}
                            {{address}}
                            {{email}}
                            {{web_site}}
                            {{facebook}}
                            {{instagram}}
                            {{twitter}}
                            {{tax_number}}
                            {{lat}}
                            {{lng}}"
    ],
    // End Store ads

    // Form
    "add_official_company_name_field" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => false,
        ]
    ],
    "require_tax_on_registration" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => false,
        ]
    ],
    'register_corporate_protection_url' => [
        'type' => 'anomaly.field_type.url',
        'config' => [
            'default_value' => '#'
        ]
    ],
	'hide_category_fields' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		],
	],
	'hide_address_fields' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		],
	],
	'hide_tax_number_fields' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		],
	],
	'hide_tax_administration' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		]
	],
    'hide_land_phone' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ],
    ],
    'hide_professional_certificate' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ],
    ],
	// End Form
    'create_store_for_profile' => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
        ]
    ],
	'hide_personal_register' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		]
	],
	'store_selection_cart' => [
		'type' => 'anomaly.field_type.boolean',
		'config' => [
			'default_value' => false,
		]
	],
    "auto_enable_corporate_member" => [
        "type"   => "anomaly.field_type.boolean",
        "bind" => "store::auto_enable_corporate_member",
        "config" => [
            "default_value" => false,
        ]
    ],
    "enable_print_button" => [
        "type" => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true
        ]
    ]
];
