<?php namespace Visiosoft\StoreModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\StoreModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\StoreModule\DopingType\Contract\DopingTypeRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class DopingsController extends PublicController
{
    protected $storeRepository;
    protected $dopingRepository;
    protected $dopingTypeRepository;

    public function __construct(
        StoreRepositoryInterface $storeRepository,
        DopingTypeRepositoryInterface $dopingTypeRepository,
        DopingRepositoryInterface $dopingRepository
    )
    {
        parent::__construct();
        $this->storeRepository = $storeRepository;
        $this->dopingRepository = $dopingRepository;
        $this->dopingTypeRepository = $dopingTypeRepository;
    }

    public function addCart($slug)
    {
        if (
            is_module_installed('visiosoft.module.carts')
            and $store = $this->storeRepository->findBySlug($slug)
            and $type = $this->dopingTypeRepository->findBy('slug', 'showcase')
        ) {
            $cart = $this->dispatch(new GetCart());
            //Create Store Doping Record
            $doping = $this->dopingRepository->createNew($store->getId(), $type->getId(), $type->getPrice());
            $doping->name = $store->getName() . "-" . $type->getName();
            $cart->add($doping, 1);
            return $this->redirect->route('visiosoft.module.carts::cart');
        }

        abort(404);
    }
}
