<?php namespace Visiosoft\StoreModule\User;

use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserRepository extends EntryRepository implements UserRepositoryInterface
{
    protected $model;
    protected $userRepository;

    public function __construct(UserModel $model, \Anomaly\UsersModule\User\Contract\UserRepositoryInterface $userRepository)
    {
        $this->model = $model;
        $this->userRepository = $userRepository;
    }

    public function getUsers($storeId)
    {
        $users = $this->findAllBy('store_id', $storeId);
        foreach ($users as $index => $user) {
            $users[$index] = $this->userRepository->find($user->user_id);
        }
        return $users;
    }

    public function findUser($userId, $storeId, $first = false)
    {
        $user = $this->newQuery()
            ->where('store_id', $storeId)
            ->where('user_id', $userId);

        if ($first) {
            $user = $user->first();
        } else {
            $user = $user->get();
        }

        return $user;
    }

    public function addUser($userId, $storeId)
    {
        return $this->create([
            'user_id' => $userId,
            'store_id' => $storeId,
        ]);
    }

    public function removeUser($userId, $storeId)
    {
        return $this->newQuery()
            ->where('store_id', $storeId)
            ->where('user_id', $userId)
            ->delete();
    }
}
