<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleStoreCreateStoreStream extends Migration
{

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'store',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'user' => [
            'required' => true,
            'warning'      => 'Please Select Store Owner',
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'summary' => [
            'translatable' => true,
            'required' => true,
        ],
        'detailed_description' => [
            'translatable' => true,
        ],
        'land_phone' => [
            'required' => true,
        ],
        'address' => [
            'required' => true,
        ],
        'category' => [
            'required' => true,
        ],
        'country' => [
            'required' => true,
        ],
        'city' => [
            'required' => true,
        ],
        'email',
        'web_site',
        'gold_supplier',
        'facebook',
        'instagram',
        'twitter',
        'file',
        'store_banner'
    ];

}
