const countryInit = () => {
    new Promise(function (resolve, reject) {
        const selectedCountry = typeof country !== 'undefined' ? country : default_country
        if (parseInt(selectedCountry)) {
            $('select[name="country"]').val(selectedCountry);
            getCities(parseInt(selectedCountry));
            if (typeof city !== 'undefined') {
                $('select[name="city"]').val(city);
            }
            resolve(true);
        }
    });
}

function getCities(country) {
    const selectCityInput = $('select[name=city]')
    selectCityInput.prop('disabled', true)
    crud(`id=${country}`, '/ajax/getCities', 'POST', function (callback) {
        cities = callback;
        $('select[name="city"]').html("<option value=''>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        selectCityInput.prop('disabled', false)
    })
}

$(document).on('change', 'select[name="country"]', function () {
    getCities($(this).val());
});

function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        async: true,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

countryInit();
