<?php namespace Visiosoft\StoreModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class StoreModule extends Module
{
    protected $navigation = true;

    protected $icon = 'fa fa-puzzle-piece';

    protected $sections = [
        'store' => [
            'buttons' => [
                'new_store',
                'export' => [
                    'href' => '/admin/store/export'
                ],
            ],
        ],
        'prices' => [
            'buttons' => [
                'new_price',
            ],
        ],
        'user' => [
            'buttons' => [
                'new_user',
                'export' => [
                    'href' => '/admin/store/user/export'
                ],
            ],
        ],
        'fields' => [
            'buttons' => [
                'add_field' => [
                    'data-toggle' => 'modal',
                    'data-target' => '#modal',
                    'href'        => 'admin/store/fields/choose',
                ],
            ],
        ],
        'category' => [
            'buttons' => [
                'new_category',
            ],
        ],
        'doping_types' => [
            'buttons' => [
                'new_doping_type',
            ],
        ],
        'dopings' => [
            'buttons' => [
                'new_doping',
            ],
        ],
        'thumb_slider' => [
        	'buttons' => [
        		'new_thumb_slider',
	        ]
        ]
    ];
}
