<?php namespace Visiosoft\StoreModule\Store\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface StoreRepositoryInterface extends EntryRepositoryInterface
{
    public function findBySlug($slug);

    public function findByUser($userId);

    public function searchStores($param = null, $limit = null, $get_query = false);

    public function searchCompanies($param = null, $limit = null, $get_query = false);

    public function getApprovedStores($orderBy = 'created_at', $orderByDir = 'desc', $limit = true);

    public function getGoldStores($orderBy = 'created_at', $orderByDir = 'desc', $limit = true);

    public function getNonGoldStores($orderBy = 'created_at', $orderByDir = 'desc', $limit = true);

    public function countByCat($catID);

    public function getStoresCount();

    public function getApprovedStoresByIds(array $ids);

    public function getStoresByCoordinates($lat, $lng, $distance = 50);

    public function getStoresAdsByUserId($id);

}
