<?php namespace Visiosoft\StoreModule\Store\Command;

use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class GetStoresByCoordinates
{
    protected $lat;
    protected $lng;
    protected $distance;

    public function __construct($lat, $lng, $distance = 50)
    {
        $this->lat = $lat;
        $this->lng = $lng;
        $this->distance = $distance;
    }

    public function handle(StoreRepositoryInterface $storeRepository)
    {
        return $storeRepository->getStoresByCoordinates($this->lat, $this->lng, $this->distance);
    }
}
