<?php namespace Visiosoft\StoreModule\Store\Form;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\StoreModule\Store\StoreModel;

class StoreFormFields
{
    public function handle(StoreFormBuilder $builder, StoreModel $store)
    {
        $fields = [
            'lat',
            'lng',
            'is_store',
            'is_company',
            'name',
            'slug',
            'user' => [
                'type' => 'anomaly.field_type.relationship',
                'config' => [
                    'related' => UserModel::class,
                    'handler' => 'Visiosoft\StoreModule\Store\Form\UsersOptions@handle',
                    'mode' => 'lookup'
                ]
            ],
            'summary',
            'detailed_description',
            'land_phone',
            'gsm_phone',
            'address',
            'category',
            'country',
            'city',
            'district' => [
                'type' => 'anomaly.field_type.select',
                'config' => [
                    'options' => [],
                ],
            ],
            'email',
            'web_site',
            'gold_supplier',
            'verified',
            'facebook',
            'instagram',
            'twitter',
            'file',
            'store_banner',
            'iban_number',
            'status',
            'tax_number',
            'tax_administration',
            'professional_certificate',
            'meta_title',
            'meta_description',
            'meta_keywords',
        ];

        $assignments = $store->getAssignments();
        $builder->setFields(array_merge($fields, $assignments->notLocked()->fieldSlugs()));
    }
}
