<?php namespace Visiosoft\StoreModule\Store\StoreRegister;

use Anomaly\UsersModule\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Illuminate\Support\Str;
use Anomaly\UsersModule\User\UserActivator;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

/**
 * Class RegisterFormHandler
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class StoreRegisterFormHandler
{

    use DispatchesJobs;

    /**
     * Handle the form.
     *
     * @param Dispatcher $events
     * @param UserRepositoryInterface $users
     * @param StoreRegisterFormBuilder $builder
     * @param UserActivator $activator
     * @param Str $str
     * @param StoreRepositoryInterface $storeRepository
     */
    public function handle(
        Dispatcher $events,
        UserRepositoryInterface $users,
        StoreRegisterFormBuilder $builder,
        UserActivator $activator,
        Str $str,
        StoreRepositoryInterface $storeRepository
    )
    {
        if (!$builder->canSave()) {
            return;
        }

        $profile_parameters = array();

        /* Create Profile in Register */
        $domain = setting_value('streams::domain');
        $domain = str_replace('https://', '', $domain);
        $domain = str_replace('http://', '', $domain);
        $domain = str_replace('/', '', $domain);
        $domain = str_replace('www', '', $domain);

        $profile_parameters['gsm_phone'] = $builder->getPostValue('phone');
        if (!setting_value('visiosoft.module.advs::register_email_field')) {
            $builder->setFormValue('email', $builder->getPostValue('username') . "@" . $domain);
        }

        $fields = $builder->getPostData();

        $fullName = $fields['first_name'] . " " . $fields['last_name'];

        // Get store fields
        $store = [
            'name' => $fullName,
            'summary' => trans('visiosoft.module.store::field.no_description_available'),
            'slug' => $str->slug($fullName),
            'category' => $fields['category'],
            'country' => $fields['country'],
            'city' => $fields['city'],
            'address' => $fields['address'],
            'land_phone' => $fields['land_phone']
        ];

        $fields['display_name'] = $fields['first_name'] . " " . $fields['last_name'];
        $fields['gsm_phone'] = $fields['phone'];
        unset($fields['phone']);
        unset($fields['category']);
        unset($fields['country']);
        unset($fields['city']);
        unset($fields['address']);
        unset($fields['land_phone']);


        $register = $users->create($fields);
        $register->setAttribute('password', $fields['password']);
        $users->save($register);

        /* @var UserInterface $user */
        $user = $register;

        $activator->start($user);
        $activator->force($user);

        // Create store
        $storeRepository->create(array_merge($store, [
            'user_id' => $user->id
        ]));

        $events->dispatch(new UserHasRegistered($user));
    }
}
