<?php namespace Visiosoft\StoreModule\Store\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class StoreTableButtons
{
    public function handle(StoreTableBuilder $builder)
    {
        $buttons = [
            'verify' => [
                'text' => function (EntryInterface $entry) {
                    $text = $entry->status === "approved" ? 'refute' : 'verify';
                    return trans('visiosoft.module.store::button.' . $text);

                },
                'icon' => function (EntryInterface $entry) {
                    return $entry->status === "approved" ? "fa fa-times-circle" : "fa fa-check-circle";
                },
                'href' => function (EntryInterface $entry) {
                    $action = $entry->status === "approved" ? 'refute' : 'verify';
                    return "/admin/store/$action/{entry.id}";
                },
                'type' => function (EntryInterface $entry) {
                    return $entry->status === "approved" ? "danger" : "success";
                },
            ],
            'edit',
        ];

        if (setting_value('visiosoft.module.store::use_subdomain_routing')) {
            $buttons['add_domain'] = [
                'text' => function (EntryInterface $entry) {
                    $text = $entry->has_domain ? 'has_domain' : 'add_domain';
                    return trans('visiosoft.module.store::button.' . $text);

                },
                'icon' => function (EntryInterface $entry) {
                    return $entry->has_domain ? "fa fa-minus-circle" : "fa fa-plus-circle";
                },
                'href' => function (EntryInterface $entry) {
                    $action = $entry->has_domain ? '#' : "/admin/store/add-domain/{entry.id}";
                    return $action;
                },
                'type' => function (EntryInterface $entry) {
                    return $entry->has_domain ? "info" : "success";
                },
                'disabled' => function (EntryInterface $entry) {
                    return $entry->has_domain ? true : false;
                },
            ];
        }

        $builder->setButtons($buttons);
    }
}
