<?php namespace Visiosoft\StoreModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Support\Facades\DB;
use Visiosoft\StoreModule\DopingType\DopingTypeSeeder;
use Visiosoft\StoreModule\Seed\RegisterInstructionSeeder;
use Visiosoft\StoreModule\ThumbSlider\Contract\ThumbSliderRepositoryInterface;

class StoreModuleSeeder extends Seeder
{
    protected $disks;
    protected $folders;
    private $thumbSliderRepository;

    public function __construct(
        DiskRepositoryInterface $disks,
        FolderRepositoryInterface $folders,
        ThumbSliderRepositoryInterface $thumbSliderRepository
    )
    {
        parent::__construct();

        $this->disks = $disks;
        $this->folders = $folders;
        $this->thumbSliderRepository = $thumbSliderRepository;
    }

    public function run()
    {
        //Doping Type Seeder
        $this->call(DopingTypeSeeder::class);

        //Create Store Icon Folder
        if (!$this->folders->findBySlug('store_icon')) {
            $disk = $this->disks->findBySlug('local');

            $this->folders->create([
                'en' => [
                    'name' => 'Store Icon',
                    'description' => 'A folder for Store Icons.',
                ],
                'slug' => 'store_icon',
                'disk' => $disk,
                'allowed_types' => [
                    'jpg', 'jpeg', 'png', 'ico', 'svg'
                ],
            ]);
        };

        //Create thumb slider
        if (!$this->thumbSliderRepository->first()) {
            $this->thumbSliderRepository->create([]);
        };

        // Register Instruction Seeder
        $this->call(RegisterInstructionSeeder::class);

        $repository = "https://raw.githubusercontent.com/openclassify/Openclassify-Demo-Data/master/";
        file_put_contents(storage_path('store.sql'), fopen($repository . "store.sql", 'r'));
        DB::unprepared(file_get_contents(storage_path('store.sql')));

    }
}