<?php namespace Visiosoft\StoreModule\Doping\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class DopingTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'store' => [
            'wrapper' => '{value.name}',
            'value' => [
                'name' => 'entry.store.getName()'
            ],
        ],
        'doping_type','status',
        'finish_at',
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
