getCountries()
    .then(function () {
        const selectedCountry = typeof country !== 'undefined' ? country : default_country
        if (parseInt(selectedCountry)) {
            $('select[name="country"]').val(selectedCountry);
            return getCities(selectedCountry)
        }
    })
    .then(function () {
        const selectedCity = typeof city !== 'undefined' ? city : default_city
        if (parseInt(selectedCity)) {
            $('select[name="city"]').val(selectedCity);
            return getDistricts(parseInt(selectedCity))
        }
    })
    .then(function () {
        if (typeof district !== 'undefined') {
            $('select[name="district"]').val(district);
        }
    });

function getCountries() {
    return crudAjax('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="country"]').html("<option>" + pick_option + "</option>");
        $.each(callback, function (index, value) {
            $('select[name="country"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
    }, true)
}

function getCities(country) {
    const selectsInput = $('select[name=city], select[name=district]')
    selectsInput.prop('disabled', true)

    $('select[name="district"]').html("<option value=''>" + pick_option + "</option>");

    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', () => {}, true)
        .then(function (cities) {
            $('select[name="city"]').html("<option value=''>" + pick_option + "</option>");
            $.each(cities, function (index, value) {
                $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectsInput.prop('disabled', false)
        })
}

function getDistricts(city) {
    const selectDistrictInput = $('select[name=district]');
    selectDistrictInput.prop('disabled', true)

    return crudAjax(`id=${city}`, '/ajax/getDistricts', 'POST', () => {}, true)
        .then(function (districts) {
            $('select[name="district"]').html("<option value=''>" + pick_option + "</option>");
            $.each(districts, function (index, value) {
                $('select[name="district"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectDistrictInput.prop('disabled', false)
        })
}

$('select[name="country"]').on('change', function () {
    getCities($(this).val());
});

$('select[name="city"]').on('change', function () {
    getDistricts($(this).val());
});
