<?php namespace Visiosoft\StoreModule\Doping;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Visiosoft\StoreModule\DopingType\Contract\DopingTypeRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class DopingCriteria extends EntryCriteria
{
    public function getStoresByType($typeSlug)
    {
        $dopingTypeRepository = app(DopingTypeRepositoryInterface::class);
        $storeRepository = app(StoreRepositoryInterface::class);

        $dopingType = $dopingTypeRepository->findBySlug($typeSlug);

        $store_ids = $this
            ->getQueryModel()
            ->newQuery()
            ->where([
                'status' => 'approved',
                'doping_type_id' => $dopingType->id,
            ])
            ->whereDate('finish_at', '>=', date("Y-m-d"))
            ->limit(setting_value('visiosoft.module.store::homeShowcaseLimit', 5))
            ->get()
            ->pluck('store_id')
            ->all();


        return $storeRepository->getApprovedStoresByIds($store_ids);
    }
}
