<?php namespace Visiosoft\StoreModule\Store;

use Anomaly\Streams\Platform\Support\Collection;
use Visiosoft\StoreModule\Store\Contract\StoreInterface;
use Anomaly\Streams\Platform\Model\Store\StoreStoreEntryModel;
use Visiosoft\StoreModule\User\UserModel;

class StoreModel extends StoreStoreEntryModel implements StoreInterface
{
    public function getName()
    {
        return $this->name;
    }

    public function approve()
    {
        return $this->update([
            'status' => 'approved'
        ]);
    }

    public function isApproved()
    {
        return $this->status === 'approved';
    }

    public function getOwner()
    {
        return $this->user;
    }

    public function getStoreUsers()
    {
        $users_store = $this->hasMany(UserModel::class, 'store_id')->get();
        $users = new Collection();
        foreach ($users_store as $user) {
            $users->add($user->getUser());
        }
        $users->add($this->user);

        return $users;
    }
}
