<?php namespace Visiosoft\StoreModule\Doping\Listeners;

use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\StoreModule\Doping\Contract\DopingRepositoryInterface;

class ApproveOrderStoreDoping
{
    protected $dopingRepository;

    public function __construct(DopingRepositoryInterface $dopingRepository)
    {
        $this->dopingRepository = $dopingRepository;
    }

    public function handle(OrderApproved $event)
    {
        foreach ($event->getOrderDetail() as $item) {
            if ($item->item_type == 'store-doping' and $doping = $this->dopingRepository->find($item->item_id)) {
                $days = ($type = $doping->getDopingType()) ? $type->getDuration() : 15;
                $doping->approve($days);
            }
        }
    }
}