<?php namespace Visiosoft\StoreModule\Category;

use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\StoreModule\Store\StoreModel;
use function Clue\StreamFilter\fun;

class CategoryRepository extends EntryRepository implements CategoryRepositoryInterface
{
    protected $model;
    protected $storeModel;

    public function __construct(CategoryModel $model)
    {
        $this->model = $model;
    }

    public function getStoreCategories($exceptions)
    {
        return $this->model->whereNotIn('store_category.id', $exceptions)->whereHas('stores', function ($query) {
            $query->where('is_store', true);
        })->get();
    }
    public function getCompanyCategories($exceptions)
    {
        return $this->model->whereNotIn('store_category.id', $exceptions)->whereHas('stores', function ($query) {
            $query->where('is_company', true);
        })->get();
    }
}
