<?php

return [
    'show_view_count' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
            "mode" => 'checkbox',
        ]
    ],

    'logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'logo_text' => [
        'type' => 'anomaly.field_type.text',
    ],
    'main_color' => [
        'type' => 'anomaly.field_type.text',
    ],
    'favicon' => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
            "mode" => "upload",
        ]
    ],
    'help_phone' => [
        'type' => 'anomaly.field_type.text',
        "config" => [
            'type' => 'tel',
            'mask' => '0(999) 999-9999'
        ]
    ],
    'banner' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ],
    ],
    'banner_link_new_tab' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
        ]
    ],
    'show_banner' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
        ]
    ],
    'warning_message' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "The ad creator is solely responsible for the content, correctness, accuracy and legal obligation of all posted ads, entries, ideas and information. openclassify.com is not in any way responsible for the quality or legality of content created and posted by its users. You should contact the ad creator directly with your questions.",
        ]
    ],
    'facebook' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'twitter' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'linkedin' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'instagram' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'youtube' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'default_owner' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => '\Anomaly\UsersModule\User\UserModel',
            "mode" => "search",
            "default_value" => null,
        ]
    ],
    'show_owner_details' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => 1
        ],
    ],
    'security_tips_msg' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "Don't make down-payment or send money before seeing the real-estate you want to buy.",
        ]
    ],
    'show_security_tips' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => 1
        ],
    ],

    'banner_link' => [
        'type' => 'anomaly.field_type.url',
        'config' => [
            'default_value' => '#',
        ],
    ],

    'playstore' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'appstore' => [
        'type' => 'anomaly.field_type.url',
        "config" => [
            'default_value' => '#',
        ]
    ],
    'shareWhatsappMsg' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            'default_value' => 'See what I found on Openclassify. Just look at the details.',
        ]
    ],
    'desktop_payment_band' => [
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ['images']
        ]
    ],
    'mobile_payment_band' => [
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ['images']
        ],
    ],
    'description_active' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'show_cart' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'contact_email' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'type' => 'email'
        ]
    ],
    'button_text' => [
        'type' => 'anomaly.field_type.text'
    ],
    'first_section_image' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => 'default',
        ],
    ],
    'first_section_heading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'first_section_subheading' => [
        'type' => 'anomaly.field_type.text'
    ],'second_section_heading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_subheading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_area1_heading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_area1_subheading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_area2_heading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_area2_subheading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_area3_heading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'second_section_area3_subheading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'third_section_heading' => [
        'type' => 'anomaly.field_type.text'
    ], 'third_section_image' =>[
        'type' => 'anomaly.field_type.file',
        'config' => [
            'folders' => ['images'],
            'mode' => 'default'
        ]
    ],
    'fourth_section_heading' => [
        'type' => 'anomaly.field_type.text'
    ],
    'fourth_section_subheading1' => [
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_subheading2' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_subheading3' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting1' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting2' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting3' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting4' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting5' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting6' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting7' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting8' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting9' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting10' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting11' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting12' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting13' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting14' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_sublisting15' =>[
        'type' => 'anomaly.field_type.text'
    ],'fourth_section_image' =>[
        'type' => 'anomaly.field_type.file',
        'config' =>[
            'folders' => ['images'],
            'mode' => 'default'
        ]
    ],
    'fifth_section_heading' =>[
        'type' => 'anomaly.field_type.text'
    ], 'fifth_section_image' =>[
        'type' => 'anomaly.field_type.file',
        'config' =>[
            'folders' => ['images'],
            'mode' => 'default'
        ]
    ], 'fifth_section_subheading' => [
        'type' => 'anomaly.field_type.text'
    ],'fifth_section_quote' =>[
        'type' => 'anomaly.field_type.text'
    ],
    'sixth_section_heading' => [
        'type' => 'anomaly.field_type.text'
    ], 'sixth_section_subheading' =>[
        'type' => 'anomaly.field_type.text'
    ]

];
