<?php namespace Visiosoft\SocialModule\Provider\Command;

use Visiosoft\SocialModule\Provider\ProviderExtension;
use Laravel\Socialite\Contracts\User;
use Laravel\Socialite\One\AbstractProvider as OAuth1Provider;

/**
 * Class GetProviderUser
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class GetProviderUser
{

    /**
     * The provider extension.
     *
     * @var ProviderExtension
     */
    protected $provider;

    /**
     * Create a new GetProviderUsers instance.
     *
     * @param ProviderExtension $provider
     */
    public function __construct(ProviderExtension $provider)
    {
        $this->provider = $provider;
    }

    /**
     * Handle the command.
     *
     * @return User
     */
    public function handle()
    {
        $provider       = $this->provider->make();
        $authentication = $this->provider->getAuthentication();

        if ($provider instanceof OAuth1Provider) {
            return $provider->userFromTokenAndSecret(
                $authentication->getAccessToken(),
                $authentication->getSecret()
            );
        }

        return $provider->userFromToken($authentication->getAccessToken());
    }
}
