<?php namespace Visiosoft\SocialModule\Authentication;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationInterface;
use Visiosoft\SocialModule\Provider\ProviderExtension;
use Anomaly\Streams\Platform\Model\Social\SocialAuthenticationsEntryModel;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Laravel\Socialite\Contracts\User;

/**
 * Class AuthenticationModel
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class AuthenticationModel extends SocialAuthenticationsEntryModel implements AuthenticationInterface
{

    /**
     * Return the authenticated provider.
     *
     * @return ProviderExtension
     */
    public function provider()
    {
        return $this
            ->getProvider()
            ->setAuthentication($this);
    }

    /**
     * Get the UID.
     *
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Get the related user.
     *
     * @return UserInterface
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Get the related user ID.
     *
     * @return int|null
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Get the access token.
     *
     * @return string
     */
    public function getAccessToken()
    {
        return $this->access_token;
    }

    /**
     * Get the refresh token.
     *
     * @return string
     */
    public function getRefreshToken()
    {
        return $this->refresh_token;
    }

    /**
     * Get the secret.
     *
     * @return string
     */
    public function getSecret()
    {
        return $this->secret;
    }

    /**
     * Get the provider.
     *
     * @return ProviderExtension
     */
    public function getProvider()
    {
        return $this->provider;
    }

    /**
     * Get the application flag.
     *
     * @return bool
     */
    public function isApplication()
    {
        return $this->application;
    }

}
