<?php namespace Visiosoft\SocialModule\Provider;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationInterface;
use Visiosoft\SocialModule\Authentication\Contract\AuthenticationRepositoryInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Laravel\Socialite\Contracts\User;

/**
 * Class ProviderAuthentication
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class ProviderAuthentication
{

    /**
     * The authentication repository.
     *
     * @var AuthenticationRepositoryInterface
     */
    protected $authentications;

    /**
     * Create a new ProviderAuthentication instance.
     *
     * @param AuthenticationRepositoryInterface $authentications
     */
    public function __construct(AuthenticationRepositoryInterface $authentications)
    {
        $this->authentications = $authentications;
    }

    /**
     * Resolve an authentication instance
     * from a social provider user.
     *
     * @param User $account
     * @param ProviderExtension $provider
     * @param UserInterface $user
     * @return AuthenticationInterface|EloquentModel|null
     */
    public function make(User $account, ProviderExtension $provider, UserInterface $user = null)
    {
        if ($user && $authentication = $this->authentications->findByUid($account->getId())) {

            $authentication->setAttribute('user', $user);
            $authentication->setAttribute('access_token', $account->token);
            $authentication->setAttribute('expires_at', $account->expiresIn);
            $authentication->setAttribute('refresh_token', $account->refreshToken);

            /* @var EloquentModel $authentication */
            $this->authentications->save($authentication);

            return $authentication;
        }

        /* @var AuthenticationInterface $authentication */
        $authentication = $this->authentications->create(
            [
                'provider'      => $provider,
                'uid'           => $account->getId(),
                'access_token'  => $account->token,
                'expires_at'    => $account->expiresIn,
                'refresh_token' => $account->refreshToken,
                'application'   => is_null($user),
            ]
        );

        if ($user) {

            $authentication->setAttribute('user', $user);

            /* @var EloquentModel $authentication */
            $this->authentications->save($authentication);
        }

        return $authentication;
    }
}
