<?php namespace Visiosoft\SocialModule\Http\Controller\Admin;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationInterface;
use Visiosoft\SocialModule\Authentication\Contract\AuthenticationRepositoryInterface;
use Visiosoft\SocialModule\Authorization\Contract\AuthorizationInterface;
use Visiosoft\SocialModule\Authorization\Contract\AuthorizationRepositoryInterface;
use Visiosoft\SocialModule\Credentials\Contract\CredentialsInterface;
use Visiosoft\SocialModule\Credentials\Contract\CredentialsRepositoryInterface;
use Visiosoft\SocialModule\Credentials\Form\CredentialsFormBuilder;
use Visiosoft\SocialModule\Provider\Command\GetProviderExtension;
use Visiosoft\SocialModule\Provider\ProviderExtension;
use Visiosoft\SocialModule\Provider\Table\ProviderTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Illuminate\Session\Store;

/**
 * Class ProvidersController
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class ProvidersController extends AdminController
{

    /**
     * Return an index of providers.
     *
     * @param ProviderTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ProviderTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Authenticate the application for a provider.
     *
     * @param AuthenticationRepositoryInterface $authentications
     * @param Store                             $session
     * @param                                   $provider
     * @return \Illuminate\Http\RedirectResponse
     * @throws \Exception
     */
    public function authenticate(
        AuthenticationRepositoryInterface $authentications,
        Store $session,
        $provider
    ) {

        /* @var ProviderExtension $extension */
        if (!$extension = $this->dispatch(new GetProviderExtension($provider))) {
            abort(404);
        }

        /* @var AuthenticationInterface|EloquentModel $authorization */
        if ($authentications->findApplicationAuthByProvider($extension->getNamespace())) {
            throw new \Exception("[{$provider}] is already authenticated.");
        }

        // Set the session parameters.
        $session->put('social::allow_registration', false);
        $session->put('social::application_authentication', true);

        return $this->redirect->to("social/{$extension->key()}/auth?redirect=admin/social");
    }

    /**
     * Invalidate a providers authentication.
     *
     * @param AuthenticationRepositoryInterface $authentications
     * @param                                   $provider
     * @return \Illuminate\Http\RedirectResponse
     */
    public function invalidate(AuthenticationRepositoryInterface $authentications, $provider)
    {

        /* @var ProviderExtension $extension */
        if (!$extension = $this->dispatch(new GetProviderExtension($provider))) {
            abort(404);
        }

        /* @var AuthenticationInterface|EloquentModel $authentication */
        $authentication = $authentications->findApplicationAuthByProvider($extension->getNamespace());

        $authentications->delete($authentication);

        return $this->redirect->back();
    }

}
