<?php namespace Visiosoft\SocialModule\Provider\Command;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationInterface;
use Visiosoft\SocialModule\Authentication\Contract\AuthenticationRepositoryInterface;
use Visiosoft\SocialModule\Authorization\Contract\AuthorizationInterface;
use Visiosoft\SocialModule\Authorization\Contract\AuthorizationRepositoryInterface;
use Visiosoft\SocialModule\Provider\ProviderExtension;

/**
 * Class GetProviderAuthentication
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class GetProviderAuthentication
{

    /**
     * The provider extension.
     *
     * @var ProviderExtension
     */
    protected $provider;

    /**
     * Create a new GetProviderAuthentication instance.
     *
     * @param ProviderExtension $provider
     */
    public function __construct(ProviderExtension $provider)
    {
        $this->provider = $provider;
    }

    /**
     * Handle the command.
     *
     * @param AuthenticationRepositoryInterface $authentications
     * @return AuthenticationInterface|null
     */
    public function handle(AuthenticationRepositoryInterface $authentications)
    {
        return $authentications->findApplicationAuthByProvider($this->provider->getNamespace());
    }
}
