<?php namespace Visiosoft\SocialModule\Authentication\Contract;

use Visiosoft\SocialModule\Provider\ProviderExtension;
use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

/**
 * Interface AuthenticationRepositoryInterface
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
interface AuthenticationRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * Find by the UID (provider's user ID).
     *
     * @param      $uid
     * @param bool $application
     * @return AuthenticationInterface|null
     */
    public function findByUid($uid, $application = false);

    /**
     * Find the application authentication.
     *
     * @param $provider
     * @return AuthenticationInterface|null
     */
    public function findApplicationAuthByProvider($provider);

}
