<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

/**
 * Class VisiosoftModuleSocialCreateSocialFields
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class VisiosoftModuleSocialCreateSocialFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'provider'      => [
            'type'   => 'anomaly.field_type.addon',
            'config' => [
                'type'   => 'extensions',
                'search' => 'visiosoft.module.social::provider.*',
            ],
        ],
        'user'          => [
            'type'   => 'anomaly.field_type.relationship',
            'config' => [
                'mode'    => 'lookup',
                'related' => \Anomaly\UsersModule\User\UserModel::class,
            ],
        ],
        'uid'           => 'anomaly.field_type.text',
        'access_token'  => [
            'type'   => 'anomaly.field_type.encrypted',
            'config' => [
                'auto_decrypt' => true,
            ],
        ],
        'refresh_token' => [
            'type'   => 'anomaly.field_type.encrypted',
            'config' => [
                'auto_decrypt' => true,
            ],
        ],
        'secret'        => [
            'type'   => 'anomaly.field_type.encrypted',
            'config' => [
                'auto_decrypt' => true,
            ],
        ],
        'expires_at'    => 'anomaly.field_type.datetime',
        'application'   => 'anomaly.field_type.boolean',
    ];

}
