<?php namespace Visiosoft\SocialModule\Provider\Table;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationRepositoryInterface;
use Visiosoft\SocialModule\Provider\ProviderExtension;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Illuminate\Contracts\Auth\Guard;

/**
 * Class ProviderTableButtons
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class ProviderTableButtons
{

    /**
     * Handle the table buttons.
     *
     * @param AuthenticationRepositoryInterface $authentications
     * @param ProviderTableBuilder $builder
     * @param Guard $auth
     */
    public function handle(
        AuthenticationRepositoryInterface $authentications,
        ProviderTableBuilder $builder,
        Guard $auth
    ) {
        /* @var UserInterface $user */
        $user = $auth->user();

        $builder->setButtons(
            [
                'authenticate' => [
                    'icon'         => 'keys',
                    'type'         => 'primary',
                    'data-toggle'  => 'confirm',
                    'text'         => 'visiosoft.module.social::button.authenticate',
                    'permission'   => 'visiosoft.module.social::providers.authenticate',
                    'data-title'   => function (ProviderExtension $entry) {
                        return trans(
                            'visiosoft.module.social::message.authenticate_title',
                            [
                                'provider' => trans($entry->getTitle()),
                            ]
                        );
                    },
                    'data-message' => function (ProviderExtension $entry) {
                        return trans(
                            'visiosoft.module.social::message.authenticate_message',
                            [
                                'provider' => trans($entry->getTitle()),
                            ]
                        );
                    },
                    'enabled'      => function (ProviderExtension $entry) use ($authentications) {
                        return !$authentications->findApplicationAuthByProvider($entry->getNamespace());
                    },
                ],
                'invalidate'   => [
                    'icon'       => 'ban',
                    'type'       => 'danger',
                    'text'       => 'visiosoft.module.social::button.invalidate',
                    'permission' => 'visiosoft.module.social::providers.authenticate',
                    'enabled'    => function (ProviderExtension $entry) use ($authentications) {
                        return $authentications->findApplicationAuthByProvider($entry->getNamespace());
                    },
                ],
                'connect'      => [
                    'icon'         => 'link',
                    'type'         => 'success',
                    'data-toggle'  => 'confirm',
                    'href'         => 'social/{entry.namespace}/auth',
                    'text'         => 'visiosoft.module.social::button.connect',
                    'data-title'   => function (ProviderExtension $entry) {
                        return trans(
                            'visiosoft.module.social::message.connect_title',
                            [
                                'provider' => trans($entry->getTitle()),
                            ]
                        );
                    },
                    'data-message' => function (ProviderExtension $entry) {
                        return trans(
                            'visiosoft.module.social::message.connect_message',
                            [
                                'provider' => trans($entry->getTitle()),
                            ]
                        );
                    },
                    'enabled'      => function (ProviderExtension $entry) use ($user) {
                        return !$user->call('authentication', ['provider' => $entry->getNamespace()]);
                    },
                ],
                'disconnect'   => [
                    'type'    => 'danger',
                    'icon'    => 'fa fa-chain-broken',
                    'href'    => 'social/{entry.namespace}/disconnect',
                    'text'    => 'visiosoft.module.social::button.disconnect',
                    'enabled' => function (ProviderExtension $entry) use ($user) {
                        return $user->call('authentication', ['provider' => $entry->getNamespace()]);
                    },
                ],
                'configure'    => [
                    'target'     => '_blank',
                    'permission' => 'anomaly.module.settings::*',
                    'href'       => 'admin/settings/extensions/{entry.namespace}',
                ],
            ]
        );
    }
}
