<?php namespace Visiosoft\SocialModule\Provider;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationInterface;
use Visiosoft\SocialModule\Provider\Command\GetProviderAuthentication;
use Visiosoft\SocialModule\Provider\Command\GetProviderScopes;
use Visiosoft\SocialModule\Provider\Command\GetProviderUser;
use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Laravel\Socialite\Contracts\Factory;
use Laravel\Socialite\Contracts\Provider;
use Laravel\Socialite\Contracts\User;
use Laravel\Socialite\One\AbstractProvider as OAuth1Provider;
use Laravel\Socialite\Two\AbstractProvider as OAuth2Provider;

/**
 * Class ProviderExtension
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class ProviderExtension extends Extension
{

    /**
     * The authentication instance.
     *
     * @var AuthenticationInterface|null
     */
    protected $authentication;

    /**
     * Return the provider key.
     *
     * @return string
     */
    public function key()
    {
        $provision = explode('.', $this->getProvides());

        return end($provision);
    }

    /**
     * Return a provider instance.
     *
     * @return Provider|OAuth1Provider|OAuth2Provider
     */
    public function make()
    {
        /* @var Factory $socialite */
        $socialite = app(Factory::class);

        return $socialite->driver($this->key());
    }

    /**
     * Return the provider's user.
     *
     * @return User
     */
    public function user()
    {
        return $this->dispatch(new GetProviderUser($this));
    }

    /**
     * Return the provider scopes.
     *
     * @param bool $application
     * @return array
     */
    public function scopes($application = false)
    {
        return $this->dispatch(new GetProviderScopes($this, $application));
    }

    /**
     * Return the provider's authorization.
     *
     * @return AuthenticationInterface|null
     */
    public function authorization()
    {
        return $this->dispatch(new GetProviderAuthentication($this));
    }

    /**
     * Get the authentication.
     *
     * @return AuthenticationInterface|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }

    /**
     * Set the authentication.
     *
     * @param AuthenticationInterface $authentication
     * @return $this
     */
    public function setAuthentication(AuthenticationInterface $authentication)
    {
        $this->authentication = $authentication;

        return $this;
    }

}
