<?php namespace Visiosoft\SocialModule\Authentication;

use Visiosoft\SocialModule\Authentication\Contract\AuthenticationInterface;
use Visiosoft\SocialModule\Authentication\Contract\AuthenticationRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

/**
 * Class AuthenticationRepository
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class AuthenticationRepository extends EntryRepository implements AuthenticationRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var AuthenticationModel
     */
    protected $model;

    /**
     * Create a new AuthenticationRepository instance.
     *
     * @param AuthenticationModel $model
     */
    public function __construct(AuthenticationModel $model)
    {
        $this->model = $model;
    }

    /**
     * Find by the UID (provider's user ID).
     *
     * @param      $uid
     * @param bool $application
     * @return AuthenticationInterface|null
     */
    public function findByUid($uid, $application = false)
    {
        return $this->model
            ->where('uid', $uid)
            ->where('application', $application)
            ->first();
    }

    /**
     * Find the application authentication.
     *
     * @param $provider
     * @return AuthenticationInterface|null
     */
    public function findApplicationAuthByProvider($provider)
    {
        return $this->model
            ->where('provider', $provider)
            ->where('application', true)
            ->first();
    }

}
