---
title: Providers
---

## Providers

Providers are extensions that wrap Socialite providers. They allow drop-in configuration and implementation.

> Provider extensions must be installed before using! {.note}

### Authenticating Users

To authenticate (login) a user with a social provider and `connect` the accounts simply send the user to the `auth` route.

> Existing authentications will simply log the user in and update tokens.{.tip}

```twig
<a href="{{ url_route('visiosoft.module.social::providers.auth', {'provider': 'facebook'}) }}">Login with Facebook</a>
```

To send the user to a specific URL after authentication you can supply a `redirect` parameter:

```twig
<a href="{{ url_route('visiosoft.module.social::providers.auth', {'provider': 'facebook', 'redirect': 'my-account/welcome'}) }}">
    Login with Facebook
</a>
```

You can specify to `register` a user if not found by email or logged in already:

```twig
<a href="{{ url_route('visiosoft.module.social::providers.auth', {'provider': 'facebook', 'register': true}) }}">
    Login with Facebook
</a>
```

> You can toggle allowing registration in Settings > Modules > Social{.tip}

#### Disconnecting Accounts

To disconnect a social provider from a user account use the `disccount` route:

```twig
<a href="{{ url_route('visiosoft.module.social::providers.disconnect', {'provider': 'facebook', 'redirect': 'my-account/providers'}) }}">
    Disconnect Facebook
</a>
```

> You can provide a `redirect` option when disconnecting too.{.tip}
