---
title: Authentications
---

## Authentications

Authentications are tokens bound to a user or the application. When accessing the `auth` route an authentication is created and updated each time the user logs in with that provider.

You can fetch authentications off a `UserInterface` instance using the `authentication` method:

```php
$authentication = $user->authentication($provider);
```

You can also fetch the application authentication directly off a `ProviderExtension` instance.

```php
$authentication = $addons->get('facebook_provider')->authentication();
```

Using the authentication you can then access all the tokens and expiration:

```php
$authentication->getAccessToken();
$authentication->getRefreshToken();
$authentication->getExpiresAt();
$authentication->getSecret(); // For OAuth1
```
 
The `provider()` method will return the authenticated provider extension. You can access the provider user this way:

```php
$authentication->provider()->user()->name
```

```twig
user().authentication('facebook').provider.user.name
```
