<?php namespace Visiosoft\SocialModule;

use Visiosoft\SocialModule\Authentication\AuthenticationModel;
use Visiosoft\SocialModule\Authentication\AuthenticationRepository;
use Visiosoft\SocialModule\Authentication\Contract\AuthenticationRepositoryInterface;
use Visiosoft\SocialModule\Provider\Command\GetProviderExtension;
use Visiosoft\SocialModule\Provider\ProviderExtension;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Addon\Extension\ExtensionCollection;
use Anomaly\Streams\Platform\Model\EloquentModel;
use Anomaly\Streams\Platform\Model\Social\SocialAuthenticationsEntryModel;
use Anomaly\UsersModule\User\UserModel;
use Illuminate\Contracts\Config\Repository;
use Laravel\Socialite\SocialiteServiceProvider;

/**
 * Class SocialModuleServiceProvider
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class SocialModuleServiceProvider extends AddonServiceProvider
{

    /**
     * The addon providers.
     *
     * @var array
     */
    protected $providers = [
        SocialiteServiceProvider::class,
    ];

    /**
     * The addon bindings.
     *
     * @var array
     */
    protected $bindings = [
        SocialAuthenticationsEntryModel::class => AuthenticationModel::class,
        SocialAuthenticationsEntryModel::class => AuthenticationModel::class,
    ];

    /**
     * The addon singletons.
     *
     * @var array
     */
    protected $singletons = [
        AuthenticationRepositoryInterface::class => AuthenticationRepository::class,
        AuthenticationRepositoryInterface::class => AuthenticationRepository::class,
    ];

    /**
     * The addon routes.
     *
     * @var array
     */
    protected $routes = [
        'social/{provider}/auth'               => [
            'as'   => 'visiosoft.module.social::providers.auth',
            'uses' => 'Visiosoft\SocialModule\Http\Controller\SocialController@auth',
        ],
        'social/{provider}/callback'           => [
            'as'   => 'visiosoft.module.social::providers.callback',
            'uses' => 'Visiosoft\SocialModule\Http\Controller\SocialController@callback',
        ],
        'social/{provider}/disconnect'         => [
            'as'   => 'visiosoft.module.social::providers.disconnect',
            'uses' => 'Visiosoft\SocialModule\Http\Controller\SocialController@disconnect',
        ],
        'admin/social'                         => 'Visiosoft\SocialModule\Http\Controller\Admin\ProvidersController@index',
        'admin/social/invalidate/{provider}'   => 'Visiosoft\SocialModule\Http\Controller\Admin\ProvidersController@invalidate',
        'admin/social/authenticate/{provider}' => 'Visiosoft\SocialModule\Http\Controller\Admin\ProvidersController@authenticate',
    ];

    /**
     * Boot the addon.
     *
     * @param ExtensionCollection $extensions
     * @param Repository          $config
     * @param UserModel           $user
     */
    public function boot(
        ExtensionCollection $extensions,
        Repository $config,
        UserModel $user
    ) {

        /**
         * Setup the hooks on the users
         * model to fetch authentications.
         */
        $user->bind(
            'authentications',
            function () {

                /* @var EloquentModel $this */
                return $this
                    ->hasMany(AuthenticationModel::class, 'user_id')
                    ->where('application', false)
                    ->getResults();
            }
        );

        $user->bind(
            'authentication',
            function ($provider) {

                /* @var ProviderExtension $extension */
                $extension = $this->dispatch(new GetProviderExtension($provider));

                /* @var EloquentModel $this */
                return $this
                    ->hasOne(AuthenticationModel::class, 'user_id')
                    ->where('provider', $extension->getNamespace())
                    ->where('application', false)
                    ->getResults();
            }
        );

        /**
         * Register the redirect services configuration.
         *
         * @var ProviderExtension $provider
         */
        foreach ($extensions->search('visiosoft.module.social::provider.*') as $provider) {
            $config->set("services.{$provider->key()}.redirect", url("social/{$provider->key()}/callback"));
        }
    }
}
