<?php namespace Visiosoft\SocialModule\Authentication\Contract;

use Visiosoft\SocialModule\Provider\ProviderExtension;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\UsersModule\User\Contract\UserInterface;

/**
 * Interface AuthenticationInterface
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
interface AuthenticationInterface extends EntryInterface
{

    /**
     * Return the authenticated provider.
     *
     * @return ProviderExtension
     */
    public function provider();

    /**
     * Get the UID.
     *
     * @return string
     */
    public function getUid();

    /**
     * Get the related user.
     *
     * @return UserInterface
     */
    public function getUser();

    /**
     * Get the related user ID.
     *
     * @return int|null
     */
    public function getUserId();

    /**
     * Get the access token.
     *
     * @return string
     */
    public function getAccessToken();

    /**
     * Get the refresh token.
     *
     * @return string
     */
    public function getRefreshToken();

    /**
     * Get the secret.
     *
     * @return string
     */
    public function getSecret();

    /**
     * Get the provider.
     *
     * @return ProviderExtension
     */
    public function getProvider();

    /**
     * Get the application flag.
     *
     * @return bool
     */
    public function isApplication();

}
