<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

/**
 * Class VisiosoftModuleSocialCreateAuthenticationsStream
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class VisiosoftModuleSocialCreateAuthenticationsStream extends Migration
{

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'authentications',
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'user',
        'provider' => [
            'required' => true,
        ],
        'uid'      => [
            'required' => true,
        ],
        'access_token',
        'refresh_token',
        'secret',
        'expires_at',
        'application',
    ];

}
