<?php namespace Visiosoft\SocialModule\Support\SettingsModule;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;

/**
 * Class RegistrationGroupsHandler
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class RegistrationGroupsHandler
{

    /**
     * Handle the command.
     *
     * @param CheckboxesFieldType $fieldType
     * @param RoleRepositoryInterface $roles
     */
    public function handle(CheckboxesFieldType $fieldType, RoleRepositoryInterface $roles)
    {
        $fieldType->setOptions(
            $roles
                ->allButAdminAndGuest()
                ->pluck('name', 'id')
                ->all()
        );
    }
}
