<?php namespace Visiosoft\SocialModule\Provider\Command;

use Visiosoft\SocialModule\Authorization\Contract\AuthorizationInterface;
use Visiosoft\SocialModule\Authorization\Contract\AuthorizationRepositoryInterface;
use Visiosoft\SocialModule\Provider\ProviderExtension;
use Illuminate\Contracts\Config\Repository;

/**
 * Class GetProviderScopes
 *
 * @link   http://visiosoft.com.tr/
 * @author Visiosoft, Inc. <support@visiosoft.com.tr>
 * @author Vedat Akdoğan <vedat@visiosoft.com.tr>
 */
class GetProviderScopes
{

    /**
     * The provider extension.
     *
     * @var ProviderExtension
     */
    protected $provider;

    /**
     * The application flag.
     *
     * @var string|null
     */
    protected $application;

    /**
     * Create a new GetProviderScopes instance.
     *
     * @param ProviderExtension $provider
     * @param boolean $application
     */
    public function __construct(ProviderExtension $provider, $application = false)
    {
        $this->provider    = $provider;
        $this->application = $application;
    }

    /**
     * Handle the command.
     *
     * @param Repository $config
     * @return array
     */
    public function handle(Repository $config)
    {
        $prefix = $this->application ? "application_" : null;

        return $config->get("services.{$this->provider->key()}.{$prefix}scope", []);
    }
}
