<?php namespace Visiosoft\SmsVerificationModule\Verification;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\SmsVerificationModule\Verification\Contract\VerificationRepositoryInterface;

class VerificationCriteria extends EntryCriteria
{
    private $verificationRepository;

    public function __construct(
        Builder $query, StreamInterface $stream, $method,
        VerificationRepositoryInterface $verificationRepository
    )
    {
        parent::__construct($query, $stream, $method);
        $this->verificationRepository = $verificationRepository;
    }

    public function isVerified($userId = null)
    {
        return $this->verificationRepository->isVerified($userId);
    }
}
