<?php namespace Visiosoft\SmsVerificationModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\SmsVerification\SmsVerificationVerificationsEntryModel;
use Visiosoft\ProfileModule\Events\UserUpdated;
use Visiosoft\SmsVerificationModule\Listeners\CheckNumberChange;
use Visiosoft\SmsVerificationModule\Verification\Contract\VerificationRepositoryInterface;
use Visiosoft\SmsVerificationModule\Verification\VerificationModel;
use Visiosoft\SmsVerificationModule\Verification\VerificationRepository;

class SmsVerificationModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        // Admin Verifications Controller
        'admin/sms_verification' => 'Visiosoft\SmsVerificationModule\Http\Controller\Admin\VerificationsController@index',
        'admin/sms_verification/create' => 'Visiosoft\SmsVerificationModule\Http\Controller\Admin\VerificationsController@create',
        'admin/sms_verification/edit/{id}' => 'Visiosoft\SmsVerificationModule\Http\Controller\Admin\VerificationsController@edit',

        // Verifications Controller
        'send-activation-sms' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.sms_verifications::send_activation_sms',
            'uses' => 'Visiosoft\SmsVerificationModule\Http\Controller\VerificationsController@sendActivationSms',
        ],
        'activate-gsm-phone' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.sms_verifications::activate_gsm_phone',
            'uses' => 'Visiosoft\SmsVerificationModule\Http\Controller\VerificationsController@activate',
        ],
        'api/activation-gms' => 'Visiosoft\SmsVerificationModule\Http\Controller\VerificationsController@apiSmsVerification',
    ];

    protected $bindings = [
        SmsVerificationVerificationsEntryModel::class => VerificationModel::class,
    ];

    protected $singletons = [
        VerificationRepositoryInterface::class => VerificationRepository::class,
    ];

    protected $listeners = [
        UserUpdated::class => [
            CheckNumberChange::class
        ],
    ];
}
