<?php namespace Visiosoft\SmsVerificationModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Crypt;
use Visiosoft\SmsModule\Commands\SendSms;
use Visiosoft\SmsModule\Listeners\RegisterVerification;
use Visiosoft\SmsModule\Template\Contract\TemplateRepositoryInterface;
use Visiosoft\SmsVerificationModule\Events\GsmVerification;
use Visiosoft\SmsVerificationModule\Events\GsmVerified;
use Visiosoft\SmsVerificationModule\Verification\Contract\VerificationRepositoryInterface;

class VerificationsController extends PublicController
{
    private $verificationRepository;
    private $userRepository;

    public function __construct(
        VerificationRepositoryInterface $verificationRepository,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();
        $this->verificationRepository = $verificationRepository;
        $this->userRepository = $userRepository;
    }

    public function sendActivationSms()
    {
        try {
            if ($this->verificationRepository->isVerified()) {
                throw new \Exception(trans('visiosoft.module.sms_verification::message.phone_already_verified'));
            }

            $activation = $this->verificationRepository->getNewCode();

            event(new GsmVerification($activation));

            return view('visiosoft.module.sms_verification::activation');
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('profile::profile');
        }
    }

    public function activate()
    {
        try {
            if (!$code = request()->code) {
                throw new \Exception(trans('visiosoft.module.sms_verification::message.code_required'));
            }

            $checkedVerification = $this->verificationRepository->checkVerification($code);

            if (!$checkedVerification) {
                throw new \Exception(trans('visiosoft.module.sms_verification::message.wrong_code'));
            }

            $checkedVerification->approve();

            event(new GsmVerified($checkedVerification));

            $this->messages->success(trans('visiosoft.module.sms_verification::message.success_message'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }
        return redirect()->route('profile::profile');
    }

    public function apiSmsVerification(Request $request)
    {
        if (\request()->phone && \request()->type === 'send-message') {
            $code = random_int(000001, 999999);
            $hashCode = Crypt::encrypt($code);
            Cookie::queue(Cookie::make('verification_code', $hashCode, 84000));

            $template = app(TemplateRepositoryInterface::class)->findBySlug('activate_gsm_sms');

            $template = $template->getTemplateForArray([
                'code' => $code
            ]);
            $msg = $template['message'];
            $phone = str_replace(' ', '', \request()->phone);
            $this->dispatch(new SendSms($phone, $msg));
        }
        if (\request()->code) {
            $hashCode = Crypt::decrypt(Cookie::get('verification_code'));
            return \request()->code == $hashCode;
        }
    }
}
