<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSmsVerificationCreateVerificationsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'verifications',
        'title_column' => 'user_id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'code' => [
            'required' => true,
        ],
        "status" => [
            'required' => true,
        ],
        'user' => [
            'required' => true,
        ],
    ];

}
