<?php namespace Visiosoft\SmsVerificationModule\Verification;

use Visiosoft\SmsVerificationModule\Verification\Contract\VerificationRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class VerificationRepository extends EntryRepository implements VerificationRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var VerificationModel
     */
    protected $model;

    /**
     * Create a new VerificationRepository instance.
     *
     * @param VerificationModel $model
     */
    public function __construct(VerificationModel $model)
    {
        $this->model = $model;
    }

    public function isVerified($userId = null)
    {
        $userId = auth_id_if_null($userId);

        $verification = $this->newQuery()
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->first();

        return $verification ? true : false;
    }

    public function getNewCode($userId = null, $status = 'pending')
    {
        $userId = auth_id_if_null($userId);

        return $this->create([
            'code' => rand(000001, 999999),
            'user_id' => $userId,
            'status' => $status
        ]);
    }

    public function checkVerification($code, $userId = null)
    {
        $userId = auth_id_if_null($userId);

        return $this->newQuery()
            ->where('code', $code)
            ->where('user_id', $userId)
            ->whereNotIn('status', ['cancelled', 'approved'])
            ->first();
    }
}
