<?php namespace Visiosoft\SmsVerificationModule\Listeners;

use Visiosoft\ProfileModule\Events\UserUpdated;
use Visiosoft\SmsVerificationModule\Verification\Contract\VerificationRepositoryInterface;

class CheckNumberChange
{
    private $verificationRepository;

    public function __construct(VerificationRepositoryInterface $verificationRepository)
    {
        $this->verificationRepository = $verificationRepository;
    }

    public function handle(UserUpdated $event)
    {
        $changes = $event->changes;
        $builder = $event->builder;

        if ($changes && count($changes) && isset($changes['gsm_phone'])) {
            $this->verificationRepository->newQuery()
                ->where('user_id', auth()->id())
                ->where('status', 'approved')
                ->update(['status' => 'pending']);

            $builder->setFormResponse(redirect(route('visiosoft.module.sms_verifications::send_activation_sms')));
        }
    }
}