<?php namespace Visiosoft\SmsVerificationModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SmsVerificationModule\Events\GsmVerification;
use Visiosoft\SmsVerificationModule\Events\GsmVerified;
use Visiosoft\SmsVerificationModule\Verification\Contract\VerificationRepositoryInterface;

class VerificationsController extends PublicController
{
    private $verificationRepository;
    private $userRepository;

    public function __construct(
        VerificationRepositoryInterface $verificationRepository,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();
        $this->verificationRepository = $verificationRepository;
        $this->userRepository = $userRepository;
    }

    public function sendActivationSms()
    {
        try {
            if ($this->verificationRepository->isVerified()) {
                throw new \Exception(trans('visiosoft.module.sms_verification::message.phone_already_verified'));
            }

            $activation = $this->verificationRepository->getNewCode();

            event(new GsmVerification($activation));

            return view('visiosoft.module.sms_verification::activation');
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('profile::profile');
        }
    }

    public function activate()
    {
        try {
            if (!$code = request()->code) {
                throw new \Exception(trans('visiosoft.module.sms_verification::message.code_required'));
            }

            $checkedVerification = $this->verificationRepository->checkVerification($code);

            if (!$checkedVerification) {
                throw new \Exception(trans('visiosoft.module.sms_verification::message.wrong_code'));
            }

            $checkedVerification->approve();

            event(new GsmVerified($checkedVerification));

            $this->messages->success(trans('visiosoft.module.sms_verification::message.success_message'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }
        return redirect()->route('profile::profile');
    }
}
