<?php namespace Visiosoft\SmsTwilioExtension;

use Anomaly\Streams\Platform\Addon\Extension\Extension;
use Twilio\Rest\Client;

class SmsTwilioExtension extends Extension
{

    protected $provides = 'visiosoft.module.sms::provider.twilio';

    /**
     * @param $number
     * @param $message
     * @return void
     * @throws \Twilio\Exceptions\ConfigurationException
     * @throws \Twilio\Exceptions\TwilioException
     */
    public function send($number, $message)
    {
        $sid = setting_value('visiosoft.extension.sms_twilio::account_sid');
        $token = setting_value('visiosoft.extension.sms_twilio::auth_token');
        $messagingServiceSid = setting_value('visiosoft.extension.sms_twilio::messaging_service_id');
        $twilio = new Client($sid, $token);
        $twilio->messages->create($number,
            [
                "messagingServiceSid" => $messagingServiceSid,
                "body" => $message
            ]);
    }
}
